      subroutine vera_jacobi__(H,EIGEN,NN,MM,ERR)
      double precision h,eigen,err
      integer mm,nn
      call vera_jacobi(H,EIGEN,NN,MM,ERR)
      end


      SUBROUTINE vera_jacobi(H,EIGEN,NN,MM,ERR)
C$$$$$ CALLS NO OTHER ROUTINES
C  JACOBI DIAGONALIZATION OF SYMMETRIC MATRICES.  SEE WILKINSON - THE
C  ALGEBRAIC EIGENVALUE PROBLEM, OUP 1964.
C  A VERSION FOR DEALING WITH HERMITIAN MATRICES IS AVAILABLE
C  H  IS A SYMMETRIC MATRIX OF ORDER  NN, DIMENSIONED H(MM,MM) IN
C  THE CALLING PROGRAM (MM.GE.NN).  ON RETURN  EIGEN  IS A REAL MATRIX
C  DIMENSIONED LIKE H, CONTAINING NORMALIZED EIGENVECTORS AS COLUMNS.
C  THE EIGENVALUES APPEAR ON THE DIAGONAL OF  H  , WHICH HAS BEEN OVER
C -WRITTEN DURING THE CALCULATION.
C  ERR  IS THE ERROR CRITERION. THE LARGEST OFF-DIAGONAL TERM WILL BE
C  AT LEAST  ERR  TIMES SMALLER THAN THE SUM OF MAGNITUDES OF EIGENVALS.
      implicit none
      double precision h,eigen,habs,big,hpp,hpq,c2,s2,cs,err
      double precision hiq,s,eignip,eigniq,hip,c,d,x,y,hqq
      double precision hij,diag
      INTEGER p,q,rots,n,nn,j,i,mm
      DIMENSION H(MM,MM),EIGEN(MM,MM)

C
      p=0
      q=0
      N=NN
      ROTS=0
C  EIGENVECTORS ARE FOUND AS THE PRODUCT MATRIX OF THE SEQUENCE OF
C  ELEMENTARY ROTATIONS THAT BRING  H  INTO DIAGONAL FORM.
      DO 110 J=1,N
      DO 100 I=1,N
100   EIGEN(I,J)=0.0d0
110   EIGEN(J,J)=1.0d0
      IF (N.EQ.1) RETURN
C  FIND THE  LARGEST  OFF-DIAGONAL ELEMNT AND PUT ITS POSITION IN P,Q
C  ALSO SUM THE DIAGONAL ELEMENTS  ABSOLUTE VALUES
 200  BIG=0.0
      DIAG=0.0
      DO 210 J=1,N
      DO 210 I=1,J
      HIJ=H(I,J)
      IF (I.EQ.J) GO TO 205
      HABS=ABS(HIJ)
      IF (BIG.GT.HABS) GO TO 210
      BIG=HABS
      P=I
      Q=J
      GO TO 210
205   DIAG=DIAG+ABS(HIJ)
210   CONTINUE
C  CHECKS ERROR CRITERION
      IF (BIG.GT.DIAG*ERR) GO TO 300
      RETURN
C
C  SETS UP VARIOUS CONSTANTS TO TRANSFORM CURRENT H
300   CONTINUE
      ROTS=ROTS+1
      HPQ=H(P,Q)
      HPP=H(P,P)
      HQQ=H(Q,Q)
      X=HPQ*SIGN(2.0d0,HPP-HQQ)
      Y=ABS(HPP-HQQ)
      D=0.5d0/SQRT(X*X+Y*Y)
      C2=0.5d0+Y*D
      C=SQRT(C2)
      CS=X*D
      S=CS/C
      S2=S*S
C
C  APPLIES ELEMENTARY UNITARY TRANSFORMS TO EIGEN, AND SIMILARITY TRANS
C -FORM TO H
      DO 310 I=1,N
      EIGNIP=EIGEN(I,P)
      EIGNIQ=EIGEN(I,Q)
      EIGEN(I,P)=EIGNIP*C+EIGNIQ*S
      EIGEN(I,Q)=EIGNIQ*C-EIGNIP*S
      IF (I.EQ.Q .OR. I.EQ.P) GO TO 310
      HIP=H(I,P)
      HIQ=H(I,Q)
      H(I,P)=HIP*C+HIQ*S
      H(P,I)=H(I,P)
      H(I,Q)=HIQ*C-HIP*S
      H(Q,I)=H(I,Q)
310   CONTINUE
C
C  DEALS WITH THE SPECIAL ELEMENTS AT P,P Q,Q AND P,Q
      H(P,P)=HPP*C2+HQQ*S2+2.0d0*CS*HPQ
      H(Q,Q)=HPP*S2+HQQ*C2-2.0d0*CS*HPQ
      H(P,Q)=0.0d0
      H(Q,P)=0.0d0
C  REPEATS ITERATION
      GO TO 200
      END
