c
c aniosotropic reflectivity package from Vera Schulte-Pelkum in March 2005
c based on code by Peter Shearer and various others, see individual READMEs 
c and source code comments for details and description
c  
c minor modifications by Thorsten Becker
c
c $Id: cinvert.f,v 1.1 2005/03/23 20:29:35 becker Exp $
c
c
c*DECK CGECO
      SUBROUTINE CGECO(A,LDA,N,IPVT,RCOND,Z)
C***BEGIN PROLOGUE  CGECO
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F4F
C***KEYWORDS  double complex,LINPACK,MATRIX,GENERAL,CONDITION,
C             CONDITION NUMBER,LINEAR EQUATIONS
C***DATE WRITTEN  AUGUST 14, 1978
C***AUTHOR  MOLER C.B. (UNM)
C***PURPOSE
C FACTORS A double complex MATRIX BY GAUSSIAN ELIMINATION AND ESTIMATES
C      THE CONDITION OF THE MATRIX.
C***DESCRIPTION
C     CGECO FACTORS A double complex MATRIX BY GAUSSIAN ELIMINATION
C     AND ESTIMATES THE CONDITION OF THE MATRIX.
C
C     IF  RCOND  IS NOT NEEDED, CGEFA IS SLIGHTLY FASTER.
C     TO SOLVE  A*X = B , FOLLOW CGECO BY CGESL.
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CGECO BY CGESL.
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CGECO BY CGEDI.
C     TO COMPUTE  INVERSE(A) , FOLLOW CGECO BY CGEDI.
C
C     ON ENTRY
C
C        A       double complex(LDA, N)
C                THE MATRIX TO BE FACTORED.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS
C                WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        RCOND   REAL
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND .
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION
C                           1.0 + RCOND .EQ. 1.0
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE
C                UNDERFLOWS.
C
C        Z       double complex(N)
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .
C
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     LINPACK CGEFA
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL
C
C***REFERENCES
C  DONGARRA J.J., BUNCH J.R., MOLER C.B., STEWART G.W.,
C   *LINPACK USERS  GUIDE*, SIAM, 1979.
C***ROUTINES CALLED  CAXPY,CSSCAL,CGEFA,SCASUM,CDOTC
C***END PROLOGUE  CGECO
      implicit double precision (a-h,o-z)
      INTEGER LDA,N,IPVT(1)
      double complex A(LDA,1),Z(1)
      REAL*8 RCOND
C
      double complex CDOTC,EK,T,WK,WKM
      REAL*8 ANORM,S,SCASUM,SM,YNORM
      INTEGER INFO,J,K,KB,KP1,L
      double complex ZDUM,ZDUM1,ZDUM2,CSIGN1
      REAL*8 CABS1
      CABS1(ZDUM) = dABS(dREAL(ZDUM)) + dABS(dIMAG(ZDUM))
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))
C
C     COMPUTE 1-NORM OF A
C
C***FIRST EXECUTABLE STATEMENT  CGECO
      ANORM = 0.0D0
      DO 10 J = 1, N
         ANORM = dMAX1(ANORM,SCASUM(N,A(1,J),1))
   10 CONTINUE
C
C     FACTOR
C
      CALL CGEFA(A,LDA,N,IPVT,INFO)
C
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  CTRANS(A)*Y = E .
C     CTRANS(A)  IS THE CONJUGATE TRANSPOSE OF A .
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.
C
C     SOLVE CTRANS(U)*W = E
C
      EK = (1.0D0,0.0D0)
      DO 20 J = 1, N
         Z(J) = (0.0D0,0.0D0)
   20 CONTINUE
      DO 100 K = 1, N
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))
         IF (CABS1(EK-Z(K)) .LE. CABS1(A(K,K))) GO TO 30
            S = CABS1(A(K,K))/CABS1(EK-Z(K))
            CALL CSSCAL(N,S,Z,1)
            EK = CMPLX(S,0.0D0)*EK
   30    CONTINUE
         WK = EK - Z(K)
         WKM = -EK - Z(K)
         S = CABS1(WK)
         SM = CABS1(WKM)
         IF (CABS1(A(K,K)) .EQ. 0.0D0) GO TO 40
            WK = WK/CONJG(A(K,K))
            WKM = WKM/CONJG(A(K,K))
         GO TO 50
   40    CONTINUE
            WK = (1.0D0,0.0D0)
            WKM = (1.0D0,0.0D0)
   50    CONTINUE
         KP1 = K + 1
         IF (KP1 .GT. N) GO TO 90
            DO 60 J = KP1, N
               SM = SM + CABS1(Z(J)+WKM*CONJG(A(K,J)))
               Z(J) = Z(J) + WK*CONJG(A(K,J))
               S = S + CABS1(Z(J))
   60       CONTINUE
            IF (S .GE. SM) GO TO 80
               T = WKM - WK
               WK = WKM
               DO 70 J = KP1, N
                  Z(J) = Z(J) + T*CONJG(A(K,J))
   70          CONTINUE
   80       CONTINUE
   90    CONTINUE
         Z(K) = WK
  100 CONTINUE
      S = 1.0D0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
C
C     SOLVE CTRANS(L)*Y = W
C
      DO 120 KB = 1, N
         K = N + 1 - KB
         IF (K .LT. N) Z(K) = Z(K) + CDOTC(N-K,A(K+1,K),1,Z(K+1),1)
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 110
            S = 1.0D0/CABS1(Z(K))
            CALL CSSCAL(N,S,Z,1)
  110    CONTINUE
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
  120 CONTINUE
      S = 1.0D0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
C
      YNORM = 1.0D0
C
C     SOLVE L*V = Y
C
      DO 140 K = 1, N
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
         IF (K .LT. N) CALL CAXPY(N-K,T,A(K+1,K),1,Z(K+1),1)
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 130
            S = 1.0D0/CABS1(Z(K))
            CALL CSSCAL(N,S,Z,1)
            YNORM = S*YNORM
  130    CONTINUE
  140 CONTINUE
      S = 1.0D0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
      YNORM = S*YNORM
C
C     SOLVE  U*Z = V
C
      DO 160 KB = 1, N
         K = N + 1 - KB
         IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 150
            S = CABS1(A(K,K))/CABS1(Z(K))
            CALL CSSCAL(N,S,Z,1)
            YNORM = S*YNORM
  150    CONTINUE
         IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)
         IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)
         T = -Z(K)
         CALL CAXPY(K-1,T,A(1,K),1,Z(1),1)
  160 CONTINUE
C     MAKE ZNORM = 1.0
      S = 1.0D0/SCASUM(N,Z,1)
      CALL CSSCAL(N,S,Z,1)
      YNORM = S*YNORM
C
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0
      RETURN
      END
c
c
c
c
*DECK CGEDI
      SUBROUTINE CGEDI(A,LDA,N,IPVT,DET,WORK,JOB)
C***BEGIN PROLOGUE  CGEDI
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F4F, F3
C***KEYWORDS  LINPACK,MATRIX,LINEAR EQUATIONS,double complex,INVERSE,
C             DETERMINANT
C***DATE WRITTEN  AUGUST 14, 1978
C***AUTHOR  MOLER C.B. (UNM)
C***PURPOSE
C  COMPUTES THE DETERMINANT AND INVERSE OF A double complex MATRIX
C   USING THE FACTORS COMPUTED BY CGECO OR CGEFA.
C***DESCRIPTION
C     CGEDI COMPUTES THE DETERMINANT AND INVERSE OF A MATRIX
C     USING THE FACTORS COMPUTED BY CGECO OR CGEFA.
C
C     ON ENTRY
C
C        A       double complex(LDA, N)
C                THE OUTPUT FROM CGECO OR CGEFA.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C        IPVT    INTEGER(N)
C                THE PIVOT VECTOR FROM CGECO OR CGEFA.
C
C        WORK    double complex(N)
C                WORK VECTOR.  CONTENTS DESTROYED.
C
C        JOB     INTEGER
C                = 11   BOTH DETERMINANT AND INVERSE.
C                = 01   INVERSE ONLY.
C                = 10   DETERMINANT ONLY.
C
C     ON RETURN
C
C        A       INVERSE OF ORIGINAL MATRIX IF REQUESTED.
C                OTHERWISE UNCHANGED.
C
C        DET     double complex(2)
C                DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.
C                OTHERWISE NOT REFERENCED.
C                DETERMINANT = DET(1) * 10.0**DET(2)
C                WITH  1.0 .LE. CABS1(DET(1)) .LT. 10.0
C                OR  DET(1) .EQ. 0.0 .
C
C     ERROR CONDITION
C
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS
C        A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.
C        IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY
C        AND IF CGECO HAS SET RCOND .GT. 0.0 OR CGEFA HAS SET
C        INFO .EQ. 0 .
C
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS CAXPY,CSCAL,CSWAP
C     FORTRAN ABS,AIMAG,CMPLX,MOD,REAL
C
C***REFERENCES
C  DONGARRA J.J., BUNCH J.R., MOLER C.B., STEWART G.W.,
C   *LINPACK USERS  GUIDE*, SIAM, 1979.
C***ROUTINES CALLED  CSWAP,CAXPY,CSCAL
C***END PROLOGUE  CGEDI
      implicit double precision (a-h,o-z)
      INTEGER LDA,N,IPVT(1),JOB
      double complex A(LDA,1),DET(2),WORK(1)
C
      double complex T
      REAL*8 TEN
      INTEGER I,J,K,KB,KP1,L,NM1
      double complex ZDUM
      REAL*8 CABS1
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))
C
C     COMPUTE DETERMINANT
C
C***FIRST EXECUTABLE STATEMENT  CGEDI
      IF (JOB/10 .EQ. 0) GO TO 70
         DET(1) = (1.0D0,0.0D0)
         DET(2) = (0.0D0,0.0D0)
         TEN = 10.0D0
         DO 50 I = 1, N
            IF (IPVT(I) .NE. I) DET(1) = -DET(1)
            DET(1) = A(I,I)*DET(1)
C        ...EXIT
            IF (CABS1(DET(1)) .EQ. 0.0D0) GO TO 60
   10       IF (CABS1(DET(1)) .GE. 1.0D0) GO TO 20
               DET(1) = dCMPLX(TEN,0.0D0)*DET(1)
               DET(2) = DET(2) - (1.0D0,0.0D0)
            GO TO 10
   20       CONTINUE
   30       IF (CABS1(DET(1)) .LT. TEN) GO TO 40
               DET(1) = DET(1)/dCMPLX(TEN,0.0D0)
               DET(2) = DET(2) + (1.0D0,0.0D0)
            GO TO 30
   40       CONTINUE
   50    CONTINUE
   60    CONTINUE
   70 CONTINUE
C
C     COMPUTE INVERSE(U)
C
      IF (MOD(JOB,10) .EQ. 0) GO TO 150
         DO 100 K = 1, N
            A(K,K) = (1.0D0,0.0D0)/A(K,K)
            T = -A(K,K)
            CALL CSCAL(K-1,T,A(1,K),1)
            KP1 = K + 1
            IF (N .LT. KP1) GO TO 90
            DO 80 J = KP1, N
               T = A(K,J)
               A(K,J) = (0.0D0,0.0D0)
               CALL CAXPY(K,T,A(1,K),1,A(1,J),1)
   80       CONTINUE
   90       CONTINUE
  100    CONTINUE
C
C        FORM INVERSE(U)*INVERSE(L)
C
         NM1 = N - 1
         IF (NM1 .LT. 1) GO TO 140
         DO 130 KB = 1, NM1
            K = N - KB
            KP1 = K + 1
            DO 110 I = KP1, N
               WORK(I) = A(I,K)
               A(I,K) = (0.0D0,0.0D0)
  110       CONTINUE
            DO 120 J = KP1, N
               T = WORK(J)
               CALL CAXPY(N,T,A(1,J),1,A(1,K),1)
  120       CONTINUE
            L = IPVT(K)
            IF (L .NE. K) CALL CSWAP(N,A(1,K),1,A(1,L),1)
  130    CONTINUE
  140    CONTINUE
  150 CONTINUE
      RETURN
      END
c
c
c
c
*DECK CAXPY
      SUBROUTINE CAXPY(N,CA,CX,INCX,CY,INCY)
C***BEGIN PROLOGUE  CAXPY
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A
C***KEYWORDS  BLAS,double complex
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C  double complex COMPUTATION Y = A*X + Y
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CA  double complex SCALAR MULTIPLIER
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C       CY  double complex VECTOR WITH N ELEMENTS
C     INCY  STORAGE SPACING BETWEEN ELEMENTS OF CY
C
C     --OUTPUT--
C       CY  double complex RESULT (UNCHANGED IF N.LE.0)
C
C     OVERWRITE double complex CY WITH double complex  CA*CX + CY.
C     FOR I = 0 TO N-1, REPLACE  CY(LY+I*INCY) WITH CA*CX(LX+I*INCX) +
C       CY(LY+I*INCY), WHERE LX = 1 IF INCX .GE. 0, ELSE LX = (-INCX)*N
C       AND LY IS DEFINED IN A SIMILAR WAY USING INCY.
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED    (NONE)
C***END PROLOGUE  CAXPY
C
      implicit double precision (a-h,o-z)
      double complex CX(1),CY(1),CA
C***FIRST EXECUTABLE STATEMENT  CAXPY
      CANORM = dABS(dREAL(CA)) + dABS(dIMAG(CA))
      IF(N.LE.0.OR.CANORM.EQ.0.E0) RETURN
      IF(INCX.EQ.INCY.AND.INCX.GT.0) GO TO 20
      KX = 1
      KY = 1
      IF(INCX.LT.0) KX = 1+(1-N)*INCX
      IF(INCY.LT.0) KY = 1+(1-N)*INCY
          DO 10 I = 1,N
          CY(KY) = CY(KY) + CA*CX(KX)
          KX = KX + INCX
          KY = KY + INCY
   10 CONTINUE
      RETURN
   20 CONTINUE
      NS = N*INCX
          DO 30 I=1,NS,INCX
          CY(I) = CA*CX(I) + CY(I)
   30     CONTINUE
      RETURN
      END
c
c
c
c
*DECK CSSCAL
      SUBROUTINE CSSCAL(N,SA,CX,INCX)
C***BEGIN PROLOGUE  CSSCAL
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A, M2
C***KEYWORDS  double complex,BLAS,SCALE,VECTOR
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE  SCALE A double complex VECTOR
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       SA  SINGLE PRECISION SCALE FACTOR
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C
C     --OUTPUT--
C       CX  SCALED RESULT (UNCHANGED IF N.LE.0)
C
C     REPLACE double complex CX BY (SINGLE PRECISION SA) * (double complex CX)
C     FOR I = 0 TO N-1, REPLACE CX(1+I*INCX) WITH  SA * CX(1+I*INCX)
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  CSSCAL
C
      implicit double precision (a-h,o-z)
      double complex CX(1)
      REAL*8    SA
C***FIRST EXECUTABLE STATEMENT  CSSCAL
      IF(N .LE. 0) RETURN
      NS = N*INCX
          DO 10 I = 1,NS,INCX
          CX(I) = SA*CX(I)
   10     CONTINUE
      RETURN
      END
c
c
c
c
*DECK CGEFA
      SUBROUTINE CGEFA(A,LDA,N,IPVT,INFO)
C***BEGIN PROLOGUE  CGEFA
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F4F
C***KEYWORDS  LINPACK,MATRIX,LINEAR EQUATIONS,double complex,FACTOR,
C             GAUSS ELIMINATION
C***DATE WRITTEN  AUGUST 14, 1978
C***AUTHOR  MOLER C.B. (UNM)
C***PURPOSE
C   FACTORS A double complex MATRIX BY GAUSSIAN ELIMINATION.
C***DESCRIPTION
C     CGEFA FACTORS A double complex MATRIX BY GAUSSIAN ELIMINATION.
C
C     CGEFA IS USUALLY CALLED BY CGECO, BUT IT CAN BE CALLED
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.
C     (TIME FOR CGECO) = (1 + 9/N)*(TIME FOR CGEFA) .
C
C     ON ENTRY
C
C        A       double complex(LDA, N)
C                THE MATRIX TO BE FACTORED.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS
C                WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        INFO    INTEGER
C                = 0  NORMAL VALUE.
C                = K  IF  U(K,K) .EQ. 0.0 .  THIS IS NOT AN ERROR
C                     CONDITION FOR THIS SUBROUTINE, BUT IT DOES
C                     INDICATE THAT CGESL OR CGEDI WILL DIVIDE BY ZERO
C                     IF CALLED.  USE  RCOND  IN CGECO FOR A RELIABLE
C                     INDICATION OF SINGULARITY.
C
C     LINPACK. THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS CAXPY,CSCAL,ICAMAX
C     FORTRAN ABS,AIMAG,REAL
C
C***REFERENCES
C  DONGARRA J.J., BUNCH J.R., MOLER C.B., STEWART G.W.,
C   *LINPACK USERS  GUIDE*, SIAM, 1979.
C***ROUTINES CALLED  CAXPY,CSCAL,ICAMAX
C***END PROLOGUE  CGEFA
      implicit double precision (a-h,o-z)
      INTEGER LDA,N,IPVT(1),INFO
      double complex A(LDA,1)
C
      double complex T
      INTEGER ICAMAX,J,K,KP1,L,NM1
      double complex ZDUM
      REAL*8 CABS1
      CABS1(ZDUM) = dABS(dREAL(ZDUM)) + dABS(dIMAG(ZDUM))
C
C     GAUSSIAN ELIMINATION WITH PARTIAL PIVOTING
C
C***FIRST EXECUTABLE STATEMENT  CGEFA
      INFO = 0
      NM1 = N - 1
      IF (NM1 .LT. 1) GO TO 70
      DO 60 K = 1, NM1
         KP1 = K + 1
C
C        FIND L = PIVOT INDEX
C
         L = ICAMAX(N-K+1,A(K,K),1) + K - 1
         IPVT(K) = L
C
C        ZERO PIVOT IMPLIES THIS COLUMN ALREADY TRIANGULARIZED
C
         IF (CABS1(A(L,K)) .EQ. 0.0D0) GO TO 40
C
C           INTERCHANGE IF NECESSARY
C
            IF (L .EQ. K) GO TO 10
               T = A(L,K)
               A(L,K) = A(K,K)
               A(K,K) = T
   10       CONTINUE
C
C           COMPUTE MULTIPLIERS
C
            T = -(1.0D0,0.0D0)/A(K,K)
            CALL CSCAL(N-K,T,A(K+1,K),1)
C
C           ROW ELIMINATION WITH COLUMN INDEXING
C
            DO 30 J = KP1, N
               T = A(L,J)
               IF (L .EQ. K) GO TO 20
                  A(L,J) = A(K,J)
                  A(K,J) = T
   20          CONTINUE
               CALL CAXPY(N-K,T,A(K+1,K),1,A(K+1,J),1)
   30       CONTINUE
         GO TO 50
   40    CONTINUE
            INFO = K
   50    CONTINUE
   60 CONTINUE
   70 CONTINUE
      IPVT(N) = N
      IF (CABS1(A(N,N)) .EQ. 0.0D0) INFO = N
      RETURN
      END
c
c
c
c
*DECK SCASUM
      FUNCTION SCASUM(N,CX,INCX)
C***BEGIN PROLOGUE  SCASUM
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A
C***KEYWORDS  BLAS,VECTOR,double complex,SUM
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C  SUM OF MAGNITUDES OF REAL AND IMAGINARY COMPONENTS OF double complex VECTOR
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C
C     --OUTPUT--
C   SCASUM  SINGLE PRECISION RESULT (ZERO IF N.LE.0)
C
C     RETURNS SUMS OF MAGNITUDES OF REAL AND IMAGINARY PARTS OF
C     COMPONENTS OF CX.  NOTE THAT THIS IS NOT THE L1 NORM OF CX.
C     CASUM = SUM FROM 0 TO N-1 OF ABS(REAL(CX(1+I*INCX))) +
C             ABS(IMAG(CX(1+I*INCX)))
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  SCASUM
      implicit double precision (a-h,o-z)
      double complex CX(1)
C***FIRST EXECUTABLE STATEMENT  SCASUM
      SCASUM=0.0d0
      IF(N .LE. 0) RETURN
      NS = N*INCX
          DO 10 I=1,NS,INCX
          SCASUM = SCASUM + dABS(dREAL(CX(I))) + dABS(dIMAG(CX(I)))
   10     CONTINUE
      RETURN
      END
c
c
c
c
*DECK CDOTC
      double complex FUNCTION CDOTC(N,CX,INCX,CY,INCY)
C***BEGIN PROLOGUE  CDOTC
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A
C***KEYWORDS  double complex,BLAS,VECTOR,DOT PRODUCT,INNER PRODUCT
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C  DOT PRODUCT OF double complex VECTORS, USES COMPLX CONJUGATE OF FIRST VECTOR
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C       CY  double complex VECTOR WITH N ELEMENTS
C     INCY  STORAGE SPACING BETWEEN ELEMENTS OF CY
C
C     --OUTPUT--
C    CDOTC  double complex RESULT (ZERO IF N.LE.0)
C
C     RETURNS THE DOT PRODUCT FOR double complex CX AND CY, USES CONJUGATE(CX)
C     CDOTC = SUM FOR I = 0 TO N-1 OF CONJ(CX(LX+I*INCX))*CY(LY+I*INCY)
C     WHERE LX = 1 IF INCX .GE. 0, ELSE LX = (-INCX)*N, AND LY IS
C     DEFINED IN A SIMILAR WAY USING INCY.
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED   (NONE)
C***END PROLOGUE  CDOTC
C
      implicit double precision (a-h,o-z)
      double complex CX(1),CY(1)
C***FIRST EXECUTABLE STATEMENT  CDOTC
      CDOTC = (0.,0.)
      IF(N .LE. 0)RETURN
      IF(INCX.EQ.INCY.AND.INCX.GT.0) GO TO 20
      KX = 1
      KY = 1
      IF(INCX.LT.0) KX = 1+(1-N)*INCX
      IF(INCY.LT.0) KY = 1+(1-N)*INCY
          DO 10 I = 1,N
          CDOTC = CDOTC + CONJG(CX(KX))*CY(KY)
          KX = KX + INCX
          KY = KY + INCY
   10     CONTINUE
      RETURN
   20 CONTINUE
      NS = N*INCX
          DO 30 I=1,NS,INCX
          CDOTC = CONJG(CX(I))*CY(I) + CDOTC
   30     CONTINUE
      RETURN
      END
c
c
c
c
*DECK CSWAP
      SUBROUTINE CSWAP(N,CX,INCX,CY,INCY)
C***BEGIN PROLOGUE  CSWAP
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A
C***KEYWORDS  double complex,BLAS,VECTOR,INTERCHANGE
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C     INTERCHANGE double complex VECTORS
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C       CY  double complex VECTOR WITH N ELEMENTS
C     INCY  STORAGE SPACING BETWEEN ELEMENTS OF CY
C
C     --OUTPUT--
C       CX  INPUT VECTOR CY (UNCHANGED IF N.LE.0)
C       CY  INPUT VECTOR CX (UNCHANGED IF N.LE.0)
C
C     INTERCHANGE double complex CX AND double complex CY
C     FOR I = 0 TO N-1, INTERCHANGE  CX(LX+I*INCX) AND CY(LY+I*INCY),
C     WHERE LX = 1 IF INCX .GT. 0, ELSE LX = (-INCX)*N, AND LY IS
C     DEFINED IN A SIMILAR WAY USING INCY.
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  CSWAP
C
      implicit double precision (a-h,o-z)
      double complex CX(1),CY(1),CTEMP
C***FIRST EXECUTABLE STATEMENT  CSWAP
      IF(N .LE. 0)RETURN
      IF(INCX.EQ.INCY.AND.INCX.GT.0) GO TO 20
      KX = 1
      KY = 1
      IF(INCX.LT.0) KX = 1+(1-N)*INCX
      IF(INCY.LT.0) KY = 1+(1-N)*INCY
          DO 10 I = 1,N
          CTEMP = CX(KX)
          CX(KX) = CY(KY)
          CY(KY) = CTEMP
          KX = KX + INCX
          KY = KY + INCY
   10 CONTINUE
      RETURN
   20 CONTINUE
      NS = N*INCX
          DO 30 I=1,NS,INCX
          CTEMP = CX(I)
          CX(I) = CY(I)
          CY(I) = CTEMP
   30     CONTINUE
      RETURN
      END
c
c
c
c
*DECK CSCAL
      SUBROUTINE CSCAL(N,CA,CX,INCX)
C***BEGIN PROLOGUE  CSCAL
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A, M2
C***KEYWORDS  double complex,BLAS,VECTOR,SCALE
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C    double complex VECTOR SCALE X = A*X
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CA  double complex SCALE FACTOR
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C
C     --OUTPUT--
C    CSCAL  double complex RESULT (UNCHANGED IF N.LE.0)
C
C     REPLACE double complex CX BY double complex CA*CX.
C     FOR I = 0 TO N-1, REPLACE CX(1+I*INCX) WITH  CA * CX(1+I*INCX)
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  CSCAL
C
      implicit double precision (a-h,o-z)
      double complex CA,CX(1)
C***FIRST EXECUTABLE STATEMENT  CSCAL
      IF(N .LE. 0) RETURN
      NS = N*INCX
          DO 10 I = 1,NS,INCX
          CX(I) = CA*CX(I)
   10     CONTINUE
      RETURN
      END
c
c
c
c
*DECK ICAMAX
      INTEGER FUNCTION ICAMAX(N,CX,INCX)
C***BEGIN PROLOGUE  ICAMAX
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  F1A
C***KEYWORDS  BLAS,VECTOR,double complex,COMPONENT,LARGEST COMPONENT
C***DATE WRITTEN  OCTOBER 1979
C***AUTHOR LAWSON C. (JPL),HANSON R. (SLA),
C                            KINCAID D. (U TEXAS), KROGH F. (JPL)
C***PURPOSE
C    FIND LARGEST COMPONENT OF double complex VECTOR
C***DESCRIPTION
C                B L A S  SUBPROGRAM
C    DESCRIPTION OF PARAMETERS
C
C     --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTOR(S)
C       CX  double complex VECTOR WITH N ELEMENTS
C     INCX  STORAGE SPACING BETWEEN ELEMENTS OF CX
C
C     --OUTPUT--
C   ICAMAX  SMALLEST INDEX (ZERO IF N.LE.0)
C
C      RETURNS THE INDEX OF THE COMPONENT OF CX HAVING THE
C      LARGEST SUM OF MAGNITUDES OF REAL AND IMAGINARY PARTS.
C     ICAMAX = FIRST I, I = 1 TO N, TO MINIMIZE
C        ABS(dREAL(CX(1-INCX+I*INCX))) + ABS(IMAG(CX(1-INCX+I*INCX)))
C
C
C***REFERENCES
C  LAWSON C.L., HANSON R.J., KINCAID D.R., KROGH F.T.,
C   *BASIC LINEAR ALGEBRA SUBPROGRAMS FOR FORTRAN USAGE*,
C  ALGORITHM NO. 539, TRANSACTIONS ON MATHEMATICAL SOFTWARE,
C  VOLUME 5, NUMBER 3, SEPTEMBER 1979, 308-323
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  ICAMAX
C
      implicit double precision (a-h,o-z)
      double complex CX(1)
C***FIRST EXECUTABLE STATEMENT  ICAMAX
      ICAMAX = 0
      IF(N.LE.0) RETURN
      ICAMAX = 1
      IF(N .LE. 1) RETURN
      NS = N*INCX
      II = 1
      SUMMAX = dABS(dREAL(CX(1))) + dABS(dIMAG(CX(1)))
          DO 20 I=1,NS,INCX
          SUMRI = dABS(dREAL(CX(I))) + dABS(dIMAG(CX(I)))
          IF(SUMMAX.GE.SUMRI) GO TO 10
          SUMMAX = SUMRI
          ICAMAX = II
   10     II = II + 1
   20     CONTINUE
      RETURN
      END
